package org.opensourcephysics.controls;

import javax.swing.text.*;
import java.awt.*;
import javax.swing.*;
import java.util.logging.*;

/**
 * A OSPFrame that displays message.
 *
 * The static MessageFrame displays logger messages when a program is run as a applet.
 *
 * @author W. Christian
 * @version 1.0
 */
public class MessageFrame  extends JFrame{
  static final Color DARK_GREEN=new Color(0, 128, 0), DARK_BLUE=new Color(0, 0, 128),DARK_RED=new Color(128, 0, 0);
  static Style black, red, blue, green, magenta, gray;
  static MessageFrame APPLET_LOG;
  static Level levelOSP=Level.INFO;
  private JTextPane textPane;

  private MessageFrame() {
    // create the panel, text pane and scroller
    this.setTitle("Message Log");
    JPanel logPanel = new JPanel(new BorderLayout());
    logPanel.setPreferredSize(new Dimension(480, 240));
    setContentPane(logPanel);
    textPane = new JTextPane();
    logPanel.setPreferredSize(new Dimension(200,300));
    logPanel.setMinimumSize(new Dimension(100,100));
    textPane.setEditable(false);
    textPane.setAutoscrolls(true);

    black = StyleContext.getDefaultStyleContext().
        getStyle(StyleContext.DEFAULT_STYLE);
    red = textPane.addStyle("red", black);
    StyleConstants.setForeground(red, DARK_RED);
    blue = textPane.addStyle("blue", black);
    StyleConstants.setForeground(blue, DARK_BLUE);
    green = textPane.addStyle("green", black);
    StyleConstants.setForeground(green, DARK_GREEN);
    magenta = textPane.addStyle("magenta", black);
    StyleConstants.setForeground(magenta, Color.MAGENTA);
    gray = textPane.addStyle("gray", black);
    StyleConstants.setForeground(gray, Color.GRAY);

    JScrollPane textScroller = new JScrollPane(textPane);
    textScroller.setWheelScrollingEnabled(true);
    logPanel.add(textScroller, BorderLayout.CENTER);
    pack();
    //show();
  }



  public static void showLog() {
    if (APPLET_LOG == null) APPLET_LOG = new MessageFrame();
    APPLET_LOG.setVisible(true);
  }


  /**
 * Sets the logger level;
 * @param level Level
 */
public static void setLevel(Level level){
 levelOSP=level;
}

/**
* Logs an severe error message.
* @param msg String
*/
public static void severe(String msg) {
appletLog(msg,MessageFrame.red);
}

/**
* Logs a warning message.
* @param msg String
*/
public static void warning(String msg) {
appletLog(msg,MessageFrame.red);
}


/**
* Logs an information message.
* @param msg String
*/
public static void info(String msg) {
appletLog(msg,MessageFrame.black);
}

/**
* Logs a configuration message.
* @param msg String
*/
public static void config(String msg) {
appletLog(msg,MessageFrame.green);
}


  /**
* Logs a fine debugging message.
* @param msg String
*/
  public static void fine(String msg) {
      appletLog(msg,MessageFrame.blue);
  }

  /**
   * Logs a finer debugging message.
   * @param msg String
   */
  public static void finer(String msg) {
    appletLog(msg, MessageFrame.blue);
  }

  /**
   * Logs a finest debugging message.
   * @param msg String
   */
  public static void finest(String msg) {
    appletLog(msg, MessageFrame.blue);
  }


  private static void appletLog(String msg, Style style) {
    if (APPLET_LOG == null) APPLET_LOG = new MessageFrame();
    try {
      Document doc = APPLET_LOG.textPane.getDocument();
      doc.insertString(doc.getLength(), msg + '\n', style);
// scroll to display new message
      Rectangle rect = APPLET_LOG.textPane.getBounds();
      rect.y = rect.height;
      APPLET_LOG.textPane.scrollRectToVisible(rect);
    }
    catch (BadLocationException ex) {
      System.err.println(ex);
    }
  }


  public static void main(String[] args) {
    MessageFrame.fine("test fine");
    APPLET_LOG.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
  }


}
