/*
 *  The org.opensourcephysics.controls package defines the framework for building
 *  user interface controls for the book Simulations in Physics.
 *  Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 *
 */
package org.opensourcephysics.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

/**
 *  A Control class for Calculations. The GUI consisting of an input text area
 *  and calculate and reset buttons designed to control a Calculation.
 *
 * @author       Wolfgang Christian
 * @author       Joshua Gould
 * @version 1.0
 */
public class CalculationTextControl extends TextControl implements Control {
  protected Calculation         calculation;
  final static String resetToolTipText = ControlsRes.CALCULATION_RESET_TIP;
  final static String calcToolTipText  = ControlsRes.CALCULATION_CALC_TIP;
  JButton             calcBtn;
  JButton             resetBtn;

  /**
   *  The CalculationTextControl constructor.
   *
   * @param  _calculation
   */
  public CalculationTextControl(Calculation _calculation) {
    super(_calculation);
    calculation = _calculation;
    calcBtn = new JButton(ControlsRes.CALCULATION_CALC);
    calcBtn.setToolTipText(calcToolTipText);
    resetBtn = new JButton(ControlsRes.CALCULATION_RESET);
    resetBtn.setToolTipText(resetToolTipText);
    calcBtn.addActionListener(new CalcBtnListener());
    resetBtn.addActionListener(new ResetBtnListener());
    buttonPanel.add(calcBtn);
    buttonPanel.add(resetBtn);
    validate();
    pack();
  }

  private class CalcBtnListener implements ActionListener {

    /**
     *  Performs the calculation and shows all drawing frames.
     *
     * @param  e
     */
    public void actionPerformed(ActionEvent e) {
      org.opensourcephysics.display.GUIUtils.showDrawingAndTableFrames();
      calculation.calculate();
    }
  }

  private class ResetBtnListener implements ActionListener {

    /**
     *  Resets the calculation.
     *
     * @param  e
     */
    public void actionPerformed(ActionEvent e) {
      calculation.resetCalculation();
    }
  }
}
