/*
 * The org.opensourcephysics.controls package defines the framework for building
 * user interface controls for the book Simulations in Physics.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.controls;

/**
 * Calculation performs a calculation in response to a control's action.
 *
 * @author Joshua Gould
 * @author Wolfgang Christian
 * @version 1.0
 */
public interface Calculation {

  /**
   * Sets object that controls this calculation.
   *
   * The calculation should use this method to register its parameters with the control.
   * This insures that the control displays the program's parameters when it appears onscreen.
   *
   * @param control
   */
  public void setControl (Control control);

  /**
   * Does the calculation.
   */
  public void calculate ();

  /**
   * Resets the simulation to a known initial state.
   */
  public void resetCalculation ();
}



