/*
 * The org.opensourcephysics.controls package defines the framework for building
 * user interface controls for the book Simulations in Physics.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.controls;
/**
 * An animation performs repetitive calculations in a separate thread.
 * Prior to starting the thread, the control should invoke initializeAnimation().
 * The thread is started when the control invokes startAnimation().
 *
 * @author Joshua Gould
 * @author Wolfgang Christian
 * @version 1.0
 */
public interface Animation {

  /**
   * Sets the object that controls this animation.
   * @param control
   */
  public void setControl (Control control);

  /**
   * Starts the animation thread.
   */
  public void startAnimation ();

  /**
   * Stops the animation thread.
   */
  public void stopAnimation ();

  /**
   * Initializes the animation.
   */
  public void initializeAnimation ();

  /**
   * Resets the animation to a known initial state.
   */
  public void resetAnimation ();

  /**
   * Performs a single animation step.
   */
  public void stepAnimation ();
}



