/*
 * The org.opensourcephysics.controls package defines the framework for building
 * user interface controls for the book Simulations in Physics.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.controls;
import java.text.DecimalFormat;
import java.awt.Frame;

/**
 * AbstractCalculation is a template for simple calculations.
 *
 * Implement the calculate method to create a calculation.
 *
 * @author       Wolfgang Christian
 * @version 1.0
 */
public abstract class AbstractCalculation implements Calculation {
    protected Control control;  // the Calculation's control
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00E0"); // display format for messages

  /**
   * Sets object that controls this calculation.
   *
   * The calculation should use this method to register its parameters with the control.
   * This insures that the control displays the program's parameters when it appears onscreen.
   *
   * @param control
   */
    public void setControl(Control control){
        this.control=control;
        if(control!=null){
           resetCalculation();
           if (control instanceof Frame) ( (Frame) control).pack();
        }
    }

    /**
     * Does the calculation.
     */
    public abstract void calculate ();

    /**
     * Resets the calculation to a predefined state.
     */
    public void resetCalculation () {
      control.clearMessages ();
      reset();
    }

    /**
     * Resets the program to its default state.
     *
     * Override this method to set the program's parameters.
     */
    public void reset() {}


}



