package JSci.maths.groups;

/**
* The DiscreteGroup class provides an abstract encapsulation for discrete groups.
* Elements are represented by strings.
* @version 1.3
* @author Mark Hale
*/
public abstract class DiscreteGroup extends Object {
        private String label;
        /**
        * Constructs a discrete group.
        * @param label a label that identifies this group
        */
        public DiscreteGroup(String aLabel) {
                label=aLabel;
        }
        /**
        * The group composition law.
        * @param a a group element
        * @param b a group element
        */
        public abstract String compose(String a,String b);
        /**
        * Returns the identity element.
        */
        public abstract String identity();
        /**
        * Returns the inverse element.
        */
        public abstract String inverse(String a);
        /**
        * Returns true if the element is the identity element of this group.
        * @param a a group element
        */
        public final boolean isIdentity(String a) {
                return identity().equals(a);
        }
        /**
        * Returns true if one element is the inverse of the other.
        * @param a a group element
        * @param b a group element
        */
        public final boolean isInverse(String a,String b) {
                return isIdentity(compose(a,b));
        }
}

