package JSci.maths.groups;

/**
* The DihedralGroup class represents the nth order dihedral group.
* Elements are represented by strings.
* @version 1.3
* @author Mark Hale
*/
public final class DihedralGroup extends DiscreteGroup {
        /**
        * The group elements.
        */
        private String elements[];
        /**
        * Constructs a dihedral group.
        * @param n order of group
        */
        public DihedralGroup(int n) {
                super("D"+n);
                elements=new String[2*n];
                elements[0]="e";
                elements[1]="b";
                StringBuffer buf=new StringBuffer(n);
                for(int i=1;i<n;i++) {
                        buf.append('c');
                        elements[i+1]=buf.toString();
                        elements[i+n]='b'+buf.toString();
                }
        }
        /**
        * The group composition law.
        * @param a a group element
        * @param b a group element
        */
        public String compose(String a,String b) {
                if(isIdentity(a))
                        return b;
                else if(isIdentity(b))
                        return a;
                else if(a.equals("b")) {
                        if(b.equals("b"))
                                return identity();
                        else if(b.charAt(0)=='b')
                                return b.substring(1);
                        else
                                return a+b;
                } else if(b.charAt(0)=='b') {
                        if(a.charAt(0)=='b') {
                                int nc=b.length()-a.length();
                                if(nc==0)
                                        return identity();
                                else if(nc<0)
                                        nc+=elements.length/2;
                                return elements[1+nc];
                        } else {
                                int nc=b.length()-1-a.length();
                                if(nc==0)
                                        return elements[1];
                                else if(nc<0)
                                        nc+=elements.length/2;
                                return elements[elements.length/2+nc];
                        }
                } else {
                        if(a.charAt(0)=='b') {
                                final String c=a+b;
                                if(c.length()>elements.length/2)
                                        return c.substring(0,c.length()-elements.length/2);
                                else
                                        return c;
                        } else {
                                final String c=a+b;
                                if(c.length()==elements.length/2)
                                        return identity();
                                if(c.length()<elements.length/2)
                                        return c;
                                else
                                        return c.substring(0,c.length()-elements.length/2);
                        }
                }
        }
        /**
        * Returns the identity element.
        */
        public String identity() {
                return elements[0];
        }
        /**
        * Returns the inverse element.
        */
        public String inverse(String a) {
                if(isIdentity(a))
                        return identity();
                else if(a.equals("b"))
                        return elements[1];
                else {
                        for(int i=2;i<elements.length;i++) {
                                if(isInverse(a,elements[i]))
                                        return elements[i];
                        }
                        return null;
                }
        }
}

