package JSci.maths.groups;

/**
* The CyclicGroup class represents the nth order cyclic group.
* Elements are represented by strings.
* @version 1.3
* @author Mark Hale
*/
public final class CyclicGroup extends DiscreteGroup {
        /**
        * The group elements.
        */
        private String elements[];
        /**
        * Constructs a cyclic group.
        * @param n order of group
        */
        public CyclicGroup(int n) {
                super("Z"+n);
                elements=new String[n];
                elements[0]="e";
                StringBuffer buf=new StringBuffer(n);
                for(int i=1;i<n;i++) {
                        buf.append('c');
                        elements[i]=buf.toString();
                }
        }
        /**
        * The group composition law.
        * @param a a group element
        * @param b a group element
        */
        public String compose(String a,String b) {
                if(isIdentity(a))
                        return b;
                else if(isIdentity(b))
                        return a;
                else {
                        final String c=a+b;
                        if(c.length()==elements.length)
                                return identity();
                        else if(c.length()<elements.length)
                                return c;
                        else
                                return c.substring(elements.length);
                }
        }
        /**
        * Returns the identity element.
        */
        public String identity() {
                return elements[0];
        }
        /**
        * Returns the inverse element.
        */
        public String inverse(String a) {
                if(isIdentity(a))
                        return identity();
                else
                        return elements[elements.length-1].substring(a.length()-1);
        }
}

