package JSci.maths.groups;

import JSci.maths.Member;

/**
* This interface defines a member of an abelian group.
* @version 1.0
* @author Mark Hale
*/
public interface AbelianGroupMember extends Member {
        /**
        * The group composition law.
        * @param g a group member
        */
        AbelianGroupMember add(AbelianGroupMember g);
        /**
        * Returns the inverse member.
        */
        AbelianGroupMember negate();
        /**
        * The group composition law with inverse.
        * @param g a group member
        */
        AbelianGroupMember subtract(AbelianGroupMember g);
}

