package JSci.maths.categories;

/**
* This interface defines a morphism.
* @version 1.0
* @author Mark Hale
*/
public interface Morphism {
        /**
        * Returns the domain.
        */
        Object domain();
        /**
        * Returns the codomain.
        */
        Object codomain();
        /**
        * Maps an object from the domain to the codomain.
        */
        Object map(Object o);
        /**
        * Returns the composition of this morphism with another.
        */
        Morphism compose(Morphism m) throws UndefinedCompositionException;
}

