package JSci.maths.categories;

/**
* The HomFunctor class encapsulates the hom bifunctor.
* @version 1.0
* @author Mark Hale
*/
public class HomFunctor extends Object implements Bifunctor {
        private Category cat;
        /**
        * Constructs the hom bifunctor for a category.
        */
        public HomFunctor(Category c) {
                cat=c;
        }
        /**
        * Maps two objects to another.
        */
        public Object map(Object a,Object b) {
                return cat.homset(a,b);
        }
        /**
        * Maps two morphisms to another.
        */
        public Morphism map(Morphism m,Morphism n) {
                return new HomMorphism(m,n);
        }
        private class HomMorphism implements Morphism {
                private Morphism in,out;
                public HomMorphism(Morphism m,Morphism n) {
                        in=m;
                        out=n;
                }
                public Object domain() {
                        return cat.homset(in.codomain(),out.domain());
                }
                public Object codomain() {
                        return cat.homset(in.domain(),out.codomain());
                }
                public Object map(Object o) {
                        return in.compose((Morphism)o).compose(out);
                }
                public Morphism compose(Morphism m) {
                        HomMorphism hm=(HomMorphism)m;
                        return new HomMorphism(hm.in.compose(in),out.compose(hm.out));
                }
        }
}

