package JSci.maths.categories;

/**
* This interface defines a functor.
* @version 1.0
* @author Mark Hale
*/
public interface Functor extends Morphism {
        /**
        * Maps an object from one category to another.
        */
        Object map(Object o);
        /**
        * Maps a morphism from one category to another.
        */
        Morphism map(Morphism m);
        /**
        * Returns the composition of this functor with another.
        */
        Functor compose(Functor f);
}

