package JSci.maths;

/**
* A collection of useful numbers (stored to maximum precision).
* @version 1.0
* @author Mark Hale
*/
public interface NumericalConstants {
        /**
        * Square root of 2.
        */
        double SQRT2=1.4142135623730950488016887242096980785696718753769;
        /**
        * Two times <img border=0 alt="pi" src="doc-files/pi.gif">.
        * @planetmath Pi
        */
        double TWO_PI=6.2831853071795864769252867665590057683943387987502;
        /**
        * Square root of 2<img border=0 alt="pi" src="doc-files/pi.gif">.
        */
        double SQRT2PI=2.5066282746310005024157652848110452530069867406099;
        /**
        * Euler's gamma constant.
        * @planetmath EulersConstant
        */
        double GAMMA=0.57721566490153286060651209008240243104215933593992;
        /**
        * Golden ratio.
        * @planetmath GoldenRatio
        */
        double GOLDEN_RATIO=1.6180339887498948482045868343656381177203091798058;
}

