package JSci.doclet;

import java.io.*;
import com.sun.javadoc.*;
import com.sun.tools.doclets.*;
import com.sun.tools.doclets.standard.*;

public class MethodSubWriter extends com.sun.tools.doclets.standard.MethodSubWriter {
        public MethodSubWriter(SubWriterHolderWriter writer, ClassDoc classdoc) {
                super(writer, classdoc);
        }
        public MethodSubWriter(SubWriterHolderWriter writer) {
                super(writer);
        }

    protected void printTags(ProgramElementDoc member) {
        MethodDoc method = (MethodDoc)member;
        ParamTag[] params = method.paramTags();
        Tag[] returns = method.tags("return");
        Tag[] sinces = method.tags("since");
        ThrowsTag[] thrown = method.throwsTags();
        SeeTag[] sees = method.seeTags();
        Tag[] planetmaths = method.tags("planetmath");
        ClassDoc[] intfacs = member.containingClass().interfaces();
        ClassDoc overridden = method.overriddenClass();
        if (intfacs.length > 0 || overridden != null) {
            printTagsInfoHeader();
            printImplementsInfo(method);
            printOverridden(overridden, method);
            printTagsInfoFooter();
        }
        if (params.length + returns.length + thrown.length + sinces.length
             + sees.length + planetmaths.length > 0) {
            printTagsInfoHeader();
            printParamTags(params);
            printReturnTag(returns);
            printThrowsTags(thrown);
            writer.printSinceTag(method);
            writer.printSeeTags(method);
            ((JSci.doclet.ClassWriter) writer).printPlanetMathTags(method);
            printTagsInfoFooter();
        } else {   // no tags are specified
            MethodDoc taggedMeth = new TaggedMethodFinder().
                                      search(method.containingClass(), method);
            if (taggedMeth != null) {
                printTagsFromTaggedMethod(taggedMeth);
            }
        }
    }
}

