package JSci.awt;

import java.awt.*;

/**
* A stacked bar graph AWT component.
* Multiple series are stacked.
* @version 1.2
* @author Lindsay Laird
*/
public class StackedBarGraph extends BarGraph {
        /**
        * Constructs a stacked bar graph.
        */
        public StackedBarGraph(CategoryGraph2DModel gm) {
                super(gm);
        }
        /**
        * Implementation of GraphDataListener.
        */
        public void dataChanged(GraphDataEvent e) {
                float tmp;
                minY=0.0f;
                maxY=Float.NEGATIVE_INFINITY;
                model.firstSeries();
                for(int i=0;i<model.seriesLength();i++) {
                        tmp=model.getValue(i);
                        while(model.nextSeries())
                                tmp+=model.getValue(i);
                        minY=Math.min(tmp,minY);
                        maxY=Math.max(tmp,maxY);
                        model.firstSeries();
                }
                if(minY==maxY) {
                        minY-=0.5f;
                        maxY+=0.5f;
                }
                setNumbering(numbering);
                rescale();
        }
        /**
        * Paint the graph.
        */
        protected void offscreenPaint(Graphics g) {
                drawAxes(g);
// bars
                Point p;
                int dy,totalDy;
                for(int i=0;i<model.seriesLength();i++) {
                        model.firstSeries();
                        if(model.getValue(i)<0.0f)
                                p=dataToScreen(i,0.0f);
                        else
                                p=dataToScreen(i,model.getValue(i));
                        g.setColor(barColor[0]);
                        dy=Math.abs(p.y-origin.y);
                        g.fillRect(p.x,p.y,barWidth,dy);
                        g.setColor(Color.black);
                        g.drawRect(p.x,p.y,barWidth,dy);
                        totalDy=dy;
                        for(int n=1;model.nextSeries();n++) {
                                if(model.getValue(i)<0.0f)
                                        p=dataToScreen(i,0.0f);
                                else
                                        p=dataToScreen(i,model.getValue(i));
                                g.setColor(barColor[n]);
                                dy=Math.abs(p.y-origin.y);
                                g.fillRect(p.x,p.y-totalDy,barWidth,dy);
                                g.setColor(Color.black);
                                g.drawRect(p.x,p.y-totalDy,barWidth,dy);
                                totalDy+=dy;
                        }
                }
        }
}

