package JSci;

import java.io.*;
import java.net.*;

/**
* The Version class contains information about the current and latest release.
* @version 1.2
* @author Mark Hale
*/
public final class Version extends Object implements Serializable {
        /**
        * Major version.
        */
        public final int majorVersion;
        /**
        * Minor version.
        */
        public final int minorVersion;
        /**
        * Version URL.
        */
        public final String versionURL;
        /**
        * Current version.
        */
        public static final Version current=new Version(0,89, "http://jsci.sourceforge.net/");
        /**
        * Retrieves the latest version at the version URL.
        */
        public static Version getLatest() throws IOException {
                Version latest=null;
                try {
                        URL serurl=new URL(current.versionURL+"version.ser");
                        ObjectInputStream in=new ObjectInputStream(serurl.openStream());
                        latest=(Version)in.readObject();
                        in.close();
                } catch(MalformedURLException murle) {
                } catch(ClassNotFoundException cnfe) {}
                return latest;
        }
        /**
        * Construct a version object.
        */
        private Version(int major,int minor,String url) {
                majorVersion=major;
                minorVersion=minor;
                versionURL=url;
        }
        /**
        * Compares two versions for equality.
        */
        public boolean equals(Object v) {
                return (v instanceof Version) &&
                        (((Version)v).majorVersion==majorVersion) &&
                        (((Version)v).minorVersion==minorVersion);
        }
        /**
        * Returns the version number as a string.
        */
        public String toString() {
                return new StringBuffer().append(majorVersion).append('.').append(minorVersion).toString();
        }
        /**
        * Returns true if this is a later version than the current version.
        */
        public boolean isLater() {
                return (majorVersion>current.majorVersion) ||
                        (majorVersion==current.majorVersion && minorVersion>current.minorVersion);
        }
}

