// Matrix.java

import java.awt.*;

public class MatrixInt extends java.awt.Panel 
{
	
	GridBagLayout gbl;
	GridBagConstraints gbc;
	GridLayout gl;
	Integer[][] matVals_int;
	Label[][] dl;
	
		
	public MatrixInt(int[][] zahl) 
	{
	  	matVals_int = new Integer[zahl.length][zahl[0].length];
	   dl = new Label[zahl.length][zahl[0].length];
	   for (int r = 0; r < zahl.length; r++) 
	   {
		   for (int c = 0; c < zahl[0].length; c++) 
		   {
			  matVals_int[r][c] = new Integer(zahl[r][c]);
			  dl[r][c] = new Label(String.valueOf(matVals_int[r][c].intValue()));
		   }
	   }	
	   initIntLayout();
	 }
		
	public MatrixInt(TextField[][] tf) 
	{
		matVals_int = new Integer[tf.length][tf[0].length];
		dl = new Label[tf.length][tf[0].length];
		for (int r = 0; r < tf.length; r++) 
		{
			for (int c = 0; c < tf[0].length; c++) 
			{
				matVals_int[r][c] = new Integer(tf[r][c].getText());
				dl[r][c] = new Label(String.valueOf(matVals_int[r][c].intValue()));
			}
		}	
		initIntLayout();
	}

	public int[][] toIntArray() 
	{
		int[][] results = new int[matVals_int.length][matVals_int[0].length];;
		for (int r = 0; r < matVals_int.length; r++) 
		{
			for (int c = 0; c < matVals_int[0].length; c++) 
			{
				results[r][c] = matVals_int[r][c].intValue();
			}
		}
		return results;
	}

	public void initIntLayout() 
	{
		gl = new GridLayout(matVals_int.length, matVals_int[0].length);
		setLayout(gl);
		for (int r = 0; r < matVals_int.length; r++) 
		{
			for (int c = 0; c < matVals_int[0].length; c++) 
			{
				dl[r][c].setAlignment(Label.CENTER);
				add(dl[r][c]);
			}
		}
	}

	// Make matrix colored
	public void setColor(Color myColor) 
	{
		for (int r = 0; r < matVals_int.length; r++) 
		{
			for (int c = 0; c < matVals_int[0].length; c++) 
			{
				dl[r][c].setForeground(myColor);
			}
		}	
	}	
		
}