import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.text.*;

public class Hueckel extends JFrame
{
   // JLabel and JTextField
   private JLabel sizeLabel;
   private JTextField sizeZahl;		
	
	HueckelWindow hw;
	
	private JButton create;	
	
   // no-argument constructor
   public Hueckel()
   {
      createUserInterface();
   }
   
   // create and position GUI components; register event handlers
   private void createUserInterface()
   {
      // get content pane for attaching GUI components
      Container contentPane = getContentPane();

      // enable explicit positioning of GUI components
      contentPane.setLayout(null);
      
      sizeLabel = new JLabel();
      sizeLabel.setBounds(16, 13, 150, 21); // (int x, int y, int width, int height)
      sizeLabel.setText("Gre der Matrix = ");
      contentPane.add(sizeLabel);
      
      // set up num1
      sizeZahl = new JTextField();
      sizeZahl.setBounds(150, 13, 20, 21);
		sizeZahl.setText("4"); 
      sizeZahl.setHorizontalAlignment(JTextField.RIGHT);
      contentPane.add(sizeZahl);      
           
      // set up num2
      /*num2 = new JTextField();
      num2.setBounds(150, 45, 20, 21);
		num2.setText("2");
      num2.setHorizontalAlignment(JTextField.RIGHT );*/
           
      // set up createJButton
      create = new JButton();
      create.setBounds(50, 70, 150, 23);
      create.setText("Create Matrix");
      contentPane.add(create);
      create.addActionListener( 
      
         new ActionListener() // anonymous inner class
         {
            // event handler called when calculateJButton is pressed
            public void actionPerformed(ActionEvent event)
            {
               calculateJButtonActionPerformed(event);
            }
            
         } // end anonymous inner class
         
      ); // end call to addActionListener
      
      // set properties of application's window
      setTitle("Hckel-Matrix"); // set title bar string
      setSize(250, 150);                 // set window size
      setVisible(true);                  // display window
      
   } // end method createUserInterface
   
   // calculate and display hypotenuse length
   private void calculateJButtonActionPerformed(ActionEvent event)
   {
      // get input from JTextFields
	  int size = Integer.parseInt(sizeZahl.getText());
	  //int absorb = Integer.parseInt(num2.getText());

      // display error message if user enters invalid input
      if (size <= 0)
      {
         JOptionPane.showMessageDialog( null,
            "You must enter positive numbers",
            "Invalid Input Entered", JOptionPane.ERROR_MESSAGE);
      }
      else
      {
         create(size);

      } // end else
      
   } // end method calculateJButtonActionPerformed
   
   public void create(int size)
   { 
     hw = new HueckelWindow(size);
     Point p = location();
     hw.move(p.x + 50, p.y + 50);
     hw.init();
     hw.show();
     hw.resize(hw.preferredSize());
     hw.validate();
   }
	   
   // main method
   public static void main( String[] args )
   {
      Hueckel application = new Hueckel();
      application.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

   } // end method main
   
} // end class Hueckel

