//package dmc;

/**
 * This class extends the DMC class to provide a potential
 * for the H2 molecule.
 *
 * @author Guenter Haucke
 */
public class DMC_H2 extends DMC
{   
   double pot, pota, potb, pota2, potb2, pot12, R, tol;
    /**
     * Constructor.  Takes one of everything and initializes the simulation.
     *
     * @param numWalkers The number of walkers to start the simulation with.
     * @param refEnergy The reference energy to start the simulation with. If it is
     *                    negative, use the current average energy of all the walkers.
     * @param refEnergyConstant Whether or not to hold the reference energy constant.
     * @param dTau The timestep to use.
     * @param alpha The feedback parameter to use (use -1.0 to use the default value
     *              of 1/dTau).
     * @param seed The long int to seed the random variate generator.
     * @param initMode The mode in which to initialize the random walkers.
     * @param param1 First parameter for the initialization mode.
     *               X_0 for delta functions, a for Uniform, mu for Gaussian
     * @param param2 Second parameter for the initialization mode.
     *               unused for delta functions, b for Uniform, sigma for Gaussian
     */
    public DMC_H2(int numWalkers, double refEnergy, boolean refEnergyConstant,
		   double dTau, double alpha, long seed,
		   int initMode, double param1, double param2)
    {
	super(numWalkers, refEnergy, refEnergyConstant,dTau,alpha,seed,
	      initMode,param1,param2);
    }

    /**
     * This constructor constructs a simulation with a delta function walker
     * initialization about point initialPosition, the seed given, and the number
     * of walkers given, but everything else with default values.
     *
     * @param numWalkers The number of walkers to start the simulation with.
     * @param initialPosition The position at which to start the walkers.
     * @param seed The long int to seed the random variate generator.
     */
    public DMC_H2(int numWalkers, double initialPosition, long seed)
    {
	super(numWalkers,initialPosition,seed);
    }


    /**
     * This is the potential energy function of the simple
     * harmonic oscillator, V = 1/2 x^2 in dimensionless units.
     *
     * @param x The point at which to get the potential
     * @return Returns the potential energy at point x
     */
    public double V(double x,double y,double z,double x2, double y2, double z2)
    {
	   //tol = 0.1;  
		//pot = - 1/(Math.abs(x)+ tol);
		R = 1.4;
		pota = - 1/(Math.sqrt((x+R/2)*(x+R/2)+y*y+z*z));
		potb = - 1/(Math.sqrt((x-R/2)*(x-R/2)+y*y+z*z));
		pota2 = - 1/(Math.sqrt((x2+R/2)*(x2+R/2)+y2*y2+z2*z2));
		potb2 = - 1/(Math.sqrt((x2-R/2)*(x2-R/2)+y2*y2+z2*z2));
		pot12 = 1/(Math.sqrt((x-x2)*(x-x2)+(y-y2)*(y-y2)+(z-z2)*(z-z2)));

		pot = pota + potb + pota2 + potb2 + pot12 + 1/R;
	   return pot;
    }
}
