// Matrix.java

import java.awt.*;
import java.text.DecimalFormat;
import java.util.*;

public class Matrix extends Panel 
{	
	GridBagLayout gbl;
	GridBagConstraints gbc;
	GridLayout gl;
	Double[][] matVals_d;
	Label[][] dl;
	
	public Matrix(double[][] mv) 
	{
		matVals_d = new Double[mv.length][mv[0].length];
		dl = new Label[mv.length][mv[0].length];
		for (int r = 0; r < mv.length; r++) {
			for (int c = 0; c < mv[0].length; c++) {
				matVals_d[r][c] = new Double(mv[r][c]);
				dl[r][c] = new Label(String.valueOf(matVals_d[r][c].doubleValue()));
			}
		}	
		initDLayout();
	}
	
	
	public Matrix(TextField[][] tf) // Umwandlung einer TextField-Matrix in eine Double-Number-Matrix
	{
		matVals_d = new Double[tf.length][tf[0].length];
		dl = new Label[tf.length][tf[0].length];
		for (int r = 0; r < tf.length; r++) 
		{
			for (int c = 0; c < tf[0].length; c++) 
			{
				matVals_d[r][c] = new Double(tf[r][c].getText());
				dl[r][c] = new Label(String.valueOf(matVals_d[r][c].doubleValue()));
			}
		}	
		initDLayout();
	}	
	
	public double[][] toDoubleArray() 
	{
		double[][] results = new double[matVals_d.length][matVals_d[0].length];;
		for (int r = 0; r < matVals_d.length; r++) 
		{
			for (int c = 0; c < matVals_d[0].length; c++) 
			{
				results[r][c] = matVals_d[r][c].doubleValue();
			}
		}
		return results;
	}
		
		
	public void initDLayout() 
	{
		gl = new GridLayout(matVals_d.length, matVals_d[0].length);
		setLayout(gl);
		for (int r = 0; r < matVals_d.length; r++) 
		{
			for (int c = 0; c < matVals_d[0].length; c++) 
			{
				dl[r][c].setAlignment(Label.CENTER);
				add(dl[r][c]);
			}
		}
	}
	
	// Make matrix colored
	public void setColor(Color myColor) 
	{
		for (int r = 0; r < matVals_d.length; r++) 
		{
			for (int c = 0; c < matVals_d[0].length; c++) 
			{
				dl[r][c].setForeground(myColor);
			}
		}	
	}	
	  
	// mit DecimalFormat
		
	public void roundD(double accuracy) 
	{
	   Locale locale = Locale.getDefault();
		Locale.setDefault(Locale.ENGLISH);
		locale = new Locale("en", "GB");
		Locale.setDefault(locale);
		
		DecimalFormat d = new DecimalFormat("#.000");
		
		for (int r = 0; r < matVals_d.length; r++) 
		{
			for (int c = 0; c < matVals_d[0].length; c++) 
			{				
				dl[r][c].setText(String.valueOf(d.format(matVals_d[r][c].doubleValue())));				
			}
		}
	}	
	
}