// HueckelWindow.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class HueckelWindow extends JFrame
{
	JPanel dispArea, controls, matPanel, oben;
	JScrollPane scrollP1, scrollP2;
	JFileChooser fChoose1 = new JFileChooser(".");
	JFileChooser fChoose2 = new JFileChooser(".");
	
	private Action saveHMat;
	private Action saveEig;
		
	TextField[][] H;
	Matrix inMat, vecMat, eigMat, eigSM;
	MatrixJama hMat, E, V, R;
	int[][] znum, spnum; // Zeilennummerierung, Spaltennummerierung
	double[][] qFeld; 
	double[][] eigVec;
	double[][] eigW;
	double[][] eigSpalte, inArr;
	double acc = 0.01; // Zahlenformat
	MatrixInt spNumH, spNumV;
	MatrixInt zNumH, zNumV;
	JLabel hLab, vLab, eLab;
	
	JButton saveH, saveEV;
	Button go;
	
	GridBagLayout gbl, ingbl, dgbl;
	GridBagConstraints cc, incc, dcc;
	
	PrintWriter output; 
	BufferedReader input;
	
	int size;
	
	Color colBlau, colRot;
		
	public HueckelWindow(int s) 
	{
		super("Hckel-Verfahren");
		size = s;
	}
		
	public void init()
	{			
		znum = new int[size][1];   // fr Darstellung der Zeilennummerierung
		for (int i = 0; i < size; i++) 
      {
			znum[i][0] = i + 1;	
		}
				
		spnum = new int[1][size];  // Bestimmung der Anzahl der Spalten
		for (int i = 0; i < size; i++) 
		{
			spnum[0][i] = i + 1;	
		}
		
		go = new Button("Go");
		saveH = new JButton("Save H-Matrix");
		saveH.addActionListener(new OpenAction1());
		saveEV = new JButton("Save Results");
		saveEV.addActionListener(new OpenAction2()); 
		
		if (size == 4) 
		{
			H = new TextField[4][4];
			H[0][0] = new TextField("0", 3);
			H[0][1] = new TextField("-1", 3);
			H[0][2] = new TextField("0", 3);
			H[0][3] = new TextField("0", 3);
			H[1][0] = new TextField("-1", 3);
			H[1][1] = new TextField("0", 3);
			H[1][2] = new TextField("-1", 3);
			H[1][3] = new TextField("0", 3);
			H[2][0] = new TextField("0", 3);
			H[2][1] = new TextField("-1", 3);
			H[2][2] = new TextField("0", 3);
			H[2][3] = new TextField("-1", 3);
			H[3][0] = new TextField("0", 3);
			H[3][1] = new TextField("0", 3);
			H[3][2] = new TextField("-1", 3);
			H[3][3] = new TextField("0", 3);
			
		}
		else 
		{
			H = new TextField[size][size];
			for (int i = 0; i < size; i++) 
			{
				for (int j = 0; j < size; j++) 
				{
					H[i][j] = new TextField("0", 3);
				}
			}			
		}		
		
		hLab = new JLabel("H");
		hLab.setHorizontalAlignment(JLabel.RIGHT);
		hLab.setOpaque(false);
		vLab = new JLabel("V");
		vLab.setHorizontalAlignment(JLabel.RIGHT);
		eLab = new JLabel("E");
		eLab.setHorizontalAlignment(JLabel.CENTER);
		
		colBlau = new Color(0, 0, 255);    // blau
		colRot = new Color(255, 0, 0);   // rot
		zNumH = new MatrixInt(znum);  // Zeilen-Nummerierung der Hckelmatrix  
		zNumH.setColor(colBlau);
		zNumV = new MatrixInt(znum);
		zNumV.setColor(colBlau);
		spNumH = new MatrixInt(spnum);
		spNumH.setColor(colBlau);
		spNumV = new MatrixInt(spnum);
		spNumV.setColor(colBlau);
				
		dispArea = new JPanel();				// Set up window
		controls = new JPanel();
		oben = new JPanel();
		matPanel = new JPanel();
		matPanel.setOpaque(false);		
		scrollP2 = new JScrollPane(dispArea);
		setLayout(new BorderLayout(5, 5));
		
		add("South", controls);
		add("North", oben);		
		add("Center", scrollP2);		
		
		ingbl = new GridBagLayout();   // fr Hckelmatrix
		incc = new GridBagConstraints();
		
		matPanel.setLayout(ingbl);
		for (int r = 0; r < size; r++) 
		{
			for (int c = 0; c < size; c++) 
			{
				incc.gridx = c;
				incc.gridy = r;
				ingbl.setConstraints(H[r][c], incc);
				matPanel.add(H[r][c]);
			}	
		}		
			
		// Label "H" = Hckelmatrix
		dgbl = new GridBagLayout();
		dcc = new GridBagConstraints();
		dispArea.setLayout(dgbl);
		dcc.fill = GridBagConstraints.BOTH;
		dcc.gridx = 2;     
		dcc.gridy = 1;    
		dcc.gridwidth = 1; 
		dcc.gridheight = 1;
		dgbl.setConstraints(hLab, dcc);
		dispArea.add(hLab);
		
		// Zeilen-Nummerierung der Inputmatrix
		dcc.gridx = 2;
		dcc.gridy = 2;  
		dcc.gridwidth = 1;
		dcc.gridheight = size;
		dgbl.setConstraints(zNumH, dcc);
		dispArea.add(zNumH);
		dispArea.setOpaque(false);  
				
		// Spalten-Nummerierung der Hckelmatrix
		dcc.gridx = 3;
		dcc.gridy = 1;   
		dcc.gridwidth = size;
		dcc.gridheight = 1;
		dgbl.setConstraints(spNumH, dcc);
		dispArea.add(spNumH);
		
		// Display Hckel-Matrix
		dcc.gridx = 3;
		dcc.gridy = 2;   
		dcc.gridwidth = size;
		dcc.gridheight = size;
		dgbl.setConstraints(matPanel, dcc);
		dispArea.add(matPanel);
		
		
		inMat = new Matrix(H);  // Input-Labelmatrix		
		inArr = inMat.toDoubleArray();				
		
		hMat = new MatrixJama(inArr); // JamaMatrix der Inputmatrix (qMat)	
		
		EigenvalueDecomposition eig = hMat.eig();  // Eigenwert-Bestimmung
		E = eig.getD();  // Eigenwert-JamaMatrix
		eigW = E.getArray();  // 2D-Array von Doubles der Eigenwerte
		eigMat = new Matrix(eigW);  // Eigenwert-Labelmatrix
		
		System.out.println(" Eigenwerte: ");  // Konsolen-Ausgabe
      E.print(5, 3);				
		
		V = eig.getV(); // Eigenvektor-JamaMatrix  
      System.out.println(" Eigenvektor-Matrix: ");   // Konsolen-Ausgabe
      V.print(5, 3);
		eigVec = V.getArray();  // 2D-Array von Doubles der Eigenvektoren
		vecMat = new Matrix(eigVec); // Eigenvektor-Labelmatrix  
				
		// Label "V" = Eigenvektor-Matrix
		dcc.gridx = 2; 
		dcc.gridy = 6 + size;
		dcc.gridwidth = 1;
		dcc.gridheight = 1;
		dgbl.setConstraints(vLab, dcc);
		dispArea.add(vLab);
		
		// Zeilen-Nummerierung der Eigenvektor-Matrix
		dcc.gridx = 2;
		dcc.gridy = 7 + size;  
		dcc.gridwidth = 1;
		dcc.gridheight = size;
		dgbl.setConstraints(zNumV, dcc);
		dispArea.add(zNumV);  
		
		// Spalten-Nummerierung der Vektormatrix
		dcc.gridx = 3;
		dcc.gridy = 6 + size;  
		dcc.gridwidth = 1;
		dcc.gridheight = 1;
		dgbl.setConstraints(spNumV, dcc);
		dispArea.add(spNumV);		
			
		// Display Vektormatrix
		dcc.gridx = 3; 
		dcc.gridy = 7 + size;  
		dcc.gridwidth = 1;  
		dcc.gridheight = size;
		
		vecMat.roundD(acc); 
		dgbl.setConstraints(vecMat, dcc); 
		dispArea.add(vecMat);  
		
		// Label "E" = Eigenwerte
		dcc.gridx = 3 + size;  
		dcc.gridy = 6 + size;
		dcc.gridwidth = 1;	
		dcc.gridheight = 1;
		dgbl.setConstraints(eLab, dcc);
		dispArea.add(eLab);
		
		// Eigenwert-Spalte
		eigSpalte = new double[size][1];   
		for (int i = 0; i < size; i++) 
      {
			eigSpalte[i][0] = eigW[i][i];	
		}
		
		eigSM = new Matrix(eigSpalte);    
		eigSM.setColor(colRot);
		eigSM.roundD(acc);
		dcc.gridx = 3 + size;  
		dcc.gridy = 7 + size;  
		dcc.gridwidth = 1;
		dcc.gridheight = size;
		dgbl.setConstraints(eigSM, dcc);
		dispArea.add(eigSM);	     	
					
		// Control-Panel
		gbl = new GridBagLayout();
		controls.setLayout(gbl);
		
		cc = new GridBagConstraints();
		
		cc.gridx = 0;
		cc.gridy = 0;
		cc.gridwidth = 2;
		gbl.setConstraints(go, cc);
		controls.add(go);
		
		validate();
		
		// oben-Panel
		
		gbl = new GridBagLayout();
		oben.setLayout(gbl);
		
		cc = new GridBagConstraints();
		
		cc.gridx = 0;
		cc.gridy = 1;
		cc.gridwidth = 2;
		gbl.setConstraints(saveH, cc);
		oben.add(saveH);
		
		cc.gridx = 3;
		cc.gridy = 1;
		cc.gridwidth = 2;
		gbl.setConstraints(saveEV, cc);
		oben.add(saveEV);
				
		validate();
	}	
 	
	// Handle events
	public boolean handleEvent(Event evt)
	{
		String minStr, maxStr;
		if (evt.target instanceof Button)
		{
			if (evt.target == go && evt.id == Event.ACTION_EVENT)	// When button is clicked
			{
        		simulate();//Integer.valueOf(num.getText()).intValue());
        		return true;					
			}
		}
		if (evt.id == Event.WINDOW_DESTROY) 
		{
			hide();
			dispose();	
		}
		return super.handleEvent(evt);	// Handle other events as usual
	}
	
	////////////////////////////////////// inner listener class OpenAction
   class OpenAction1 implements ActionListener 
   {
     public void actionPerformed(ActionEvent e) 
     {
       int retval = fChoose1.showOpenDialog(HueckelWindow.this);
       if (retval == JFileChooser.APPROVE_OPTION) 
       {
         File f = fChoose1.getSelectedFile();
         try 
         {
           DecimalFormat fmt = new DecimalFormat("0.00");
           PrintWriter pW = new PrintWriter(new FileOutputStream(f));           
           hMat.print(pW, fmt, 5);
           pW.close();
         } 
         catch (IOException ioex) 
         {
           System.out.println(e);
           System.exit(1);
         }
		 }
		         
     } //end actionPerformed
   } //end inner listener class OpenAction
	
   class OpenAction2 implements ActionListener 
   {
     public void actionPerformed(ActionEvent e) 
     {
       int retval = fChoose2.showOpenDialog(HueckelWindow.this);
       if (retval == JFileChooser.APPROVE_OPTION) 
       {
         File f = fChoose1.getSelectedFile();
         try 
         {
           DecimalFormat fmt = new DecimalFormat("0.0000");
           PrintWriter pW = new PrintWriter(new FileOutputStream(f));           
           E.print(pW, fmt, 5);
			  V.print(pW, fmt, 5);
           pW.close();
         } 
         catch (IOException ioex) 
         {
           System.out.println(e);
           System.exit(1);
         }
		 }
		         
     } //end actionPerformed
   } //end inner listener class OpenAction
	
	
	//  nach Button go +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	  public void simulate()
    {	
	   dispArea.remove(vecMat);
    	dispArea.remove(eigSM);
    	    	
    	inMat = new Matrix(H);
		inArr = inMat.toDoubleArray();				
		
		hMat = new MatrixJama(inArr); // JamaMatrix der Inputmatrix (qMat)  
		
    	EigenvalueDecomposition eig = hMat.eig();  // Eigenwert-Bestimmung
		E = eig.getD();  // Eigenwert-JamaMatrix
		eigW = E.getArray();  // 2D-Array von Doubles der Eigenwerte
		eigMat = new Matrix(eigW);  // Eigenwert-Matrix
		
		System.out.println(" Eigenwerte: ");
      E.print(5, 3);
		
		V = eig.getV(); // Eigenvektor-JamaMatrix  
      System.out.println(" Eigenvektor-Matrix: ");
      V.print(5, 3);
		eigVec = V.getArray();  // 2D-Array von Doubles der Eigenvektoren
		vecMat = new Matrix(eigVec); // Eigenvektor-Matrix  
						
		// Display Vektormatrix
		dcc.gridx = 3;
		dcc.gridy = 7 + size;
		dcc.gridwidth = 1;
		dcc.gridheight = size;
	   vecMat.roundD(acc); 
      dgbl.setConstraints(vecMat, dcc); 
      dispArea.add(vecMat); 
					
		// Display Eigenwerte als Spalte
		eigSpalte = new double[size][1];   
		for (int i = 0; i < size; i++) 
      {
			eigSpalte[i][0] = eigW[i][i];	
		}
		
		eigSM = new Matrix(eigSpalte);    
		eigSM.setColor(colRot);
		eigSM.roundD(acc);
		dcc.gridx = 3 + size;
		dcc.gridy = 7 + size;  
		dcc.gridwidth = 1;
		dcc.gridheight = size;
		dgbl.setConstraints(eigSM, dcc);
		dispArea.add(eigSM);              
				 	
    	validate();
	}
}




