import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.text.*;
import java.io.*;

public class Hueckel extends JFrame
{
   // JLabel and JTextField
   private JLabel sizeLabel, oderLabel;
   private JTextField sizeZahl;
	private int dim;		
	
	HueckelWindow hw;
	MatrixJama R;
	FileWindow fW;
	
	private JButton create, openFile;
	private JFileChooser m_fc = new JFileChooser(".");
	private JTextArea m_fileContents = new JTextArea(20, 80);
	
   // no-argument constructor
   public Hueckel()
   {
      createUserInterface();
	
   }
   
   // create and position GUI components; register event handlers
   private void createUserInterface()
   {
      // get content pane for attaching GUI components
      Container contentPane = getContentPane();

      // enable explicit positioning of GUI components
      contentPane.setLayout(null);
      
      sizeLabel = new JLabel();
      sizeLabel.setBounds(16, 13, 150, 21); // (int x, int y, int width, int height)
      sizeLabel.setText("Gre der Matrix = ");
      contentPane.add(sizeLabel);
		
		oderLabel = new JLabel();
      oderLabel.setBounds(110, 90, 150, 21); // (int x, int y, int width, int height)
      oderLabel.setText("oder");
      contentPane.add(oderLabel);

      
      // set up num1
      sizeZahl = new JTextField();
      sizeZahl.setBounds(150, 13, 20, 21);
		sizeZahl.setText("4"); 
      sizeZahl.setHorizontalAlignment(JTextField.RIGHT);
      contentPane.add(sizeZahl);    
           
             
      // set up createJButton
      create = new JButton();
      create.setBounds(50, 40, 150, 23);
      create.setText("Create Matrix");
      contentPane.add(create);
      create.addActionListener( 
      
         new ActionListener() // anonymous inner class
         {
            // event handler called when calculateJButton is pressed
            public void actionPerformed(ActionEvent event)
            {
               calculateJButtonActionPerformed(event);
            }
            
         } // end anonymous inner class
         
      ); // end call to addActionListener
		
		// set up openFile-JButton
		openFile = new JButton();
		openFile.setBounds(50, 110, 150, 23);
		openFile.setText("open Matrix-File");
		contentPane.add(openFile);
		
		openFile.addActionListener(new OpenAction());
		
	      
      // set properties of application's window
      setTitle("Hckel-Matrix"); // set title bar string
      setSize(250, 200);                 // set window size
      setVisible(true);                  // display window
      
   } // end method createUserInterface
   
   // bergabe von size
   private void calculateJButtonActionPerformed(ActionEvent event)
   {
      // get input from JTextFields
	  int size = Integer.parseInt(sizeZahl.getText());
	  
      // display error message if user enters invalid input
      if (size <= 0)
      {
         JOptionPane.showMessageDialog( null,
            "You must enter positive numbers",
            "Invalid Input Entered", JOptionPane.ERROR_MESSAGE);
      }
      else
      {
         create(size);

      } // end else
      
   } // end method calculateJButtonActionPerformed
   
   public void create(int size)
   { 
     hw = new HueckelWindow(size);
     //Point p = location();
	  Point p = new Point(); // neu
     hw.move(p.x + 50, p.y + 50);
     hw.init();
     //hw.show();
	  hw.setVisible(true);   // neu
     //hw.resize(hw.preferredSize());
	  hw.setSize(hw.getPreferredSize());  // neu
     hw.validate();
   }
	
	// File-Transfer zu FileWindow
	
	public void fileTrans(MatrixJama R)
	{
	   fW = new FileWindow(R);
		Point p = new Point();
		fW.move(p.x + 50, p.y + 50);
		fW.init();
		fW.setVisible(true);
		fW.setSize(fW.getPreferredSize());
		fW.validate();
	 }
	
	////////////////////////////////////// inner listener class OpenAction
   class OpenAction implements ActionListener 
   {
     public void actionPerformed(ActionEvent e) 
     {
       int retval = m_fc.showOpenDialog(Hueckel.this);
       if (retval == JFileChooser.APPROVE_OPTION) 
       {
         File inFile = m_fc.getSelectedFile();
         try 
         {
           FileReader fr = new FileReader(inFile);
			  
			 R = MatrixJama.read(new BufferedReader(new FileReader(inFile)));
			
           BufferedReader bufRdr = new BufferedReader(fr);
			  System.out.println("mit JFileChooser Datei einlesen");
			  R.print(5, 3);
			  dim = R.getRowDimension();
			  System.out.println("Row Dimension dim: " + dim);
			  
			  fileTrans(R);

           String line = null;
           while ((line = bufRdr.readLine()) != null)
           {
             m_fileContents.append(line);
             m_fileContents.append("\n");
           }
           bufRdr.close();

         } 
         catch (IOException ioex) 
         {
           System.err.println(ioex);
           System.exit(1);
         }
			
       }
     }   //end actionPerformed
   }   //end inner listener class OpenAction

	   
   // main method
   public static void main( String[] args )
   {
      Hueckel application = new Hueckel();
      application.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

   } // end method main
   
} // end class Hueckel

