// FileWindow.java

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class FileWindow extends JFrame
{
	JPanel dispArea;
	JPanel controls;		
	JPanel matPanel;
	JScrollPane scrollP;
		
	Matrix inMat, vecMat, eigMat, eigSM;
	MatrixJama hMat, E, V, R;
	
	int[][] znum, spnum; // Zeilennummerierung, Spaltennummerierung
	double[][] hArr, eigVec, eigW, eigSpalte, inArr; 
	double acc = 0.01; // Zahlenformat
	MatrixInt spNumH, spNumV, zNumH, zNumV;
	JLabel hLab, vLab, eLab;
	
	JButton erg;
	JFileChooser fChoose = new JFileChooser(".");
	Action saveEig;
	
	GridBagLayout gbl, ingbl, dgbl;
	GridBagConstraints cc, incc, dcc;
	
	PrintWriter output; 
	BufferedReader input;
	
	int size;
	
	Color colBlau, colRot;
		
	public FileWindow(MatrixJama R) 
	{
		super("Hckel-Verfahren");
		hMat = R;
		size = R.getRowDimension();
		System.out.println("size = " + size);
	}
		
	public void init()
	{			
		znum = new int[size][1];   // fr Darstellung der Zeilennummerierung
		for (int i = 0; i < size; i++) 
      {
			znum[i][0] = i + 1;	
		}
				
		spnum = new int[1][size];  // Bestimmung der Anzahl der Spalten
		for (int i = 0; i < size; i++) 
		{
			spnum[0][i] = i + 1;	
		}
		
		erg = new JButton("Ergebnis speichern");		
		erg.addActionListener(new OpenAction());		
					
		hLab = new JLabel("H");
		hLab.setHorizontalAlignment(JLabel.RIGHT);
		vLab = new JLabel("V");
		vLab.setHorizontalAlignment(JLabel.RIGHT);
		eLab = new JLabel("E");
		eLab.setHorizontalAlignment(JLabel.CENTER);
		
		colBlau = new Color(0, 0, 255);    // blau
		colRot = new Color(255, 0, 0);   // rot
		zNumH = new MatrixInt(znum);  // Zeilen-Nummerierung der Hckelmatrix  
		zNumH.setColor(colBlau);	
		zNumV = new MatrixInt(znum);
		zNumV.setColor(colBlau);
		spNumH = new MatrixInt(spnum);
		spNumH.setColor(colBlau);
		spNumV = new MatrixInt(spnum);
		spNumV.setColor(colBlau);
				
		dispArea = new JPanel();				// Set up window
		controls = new JPanel();
		matPanel = new JPanel();  // fr H-Matrix
		scrollP = new JScrollPane(dispArea);
		setLayout(new BorderLayout(5, 5));
		
		add("South", controls);
		add("Center", scrollP);
		
		ingbl = new GridBagLayout();   // fr Hckelmatrix
		incc = new GridBagConstraints();
		
		matPanel.setLayout(ingbl);
		hArr = hMat.getArray();
		inMat = new Matrix(hArr);
		for (int r = 0; r < size; r++) 
		{
			for (int c = 0; c < size; c++) 
			{
				incc.gridx = c;
				incc.gridy = r;
				ingbl.setConstraints(inMat, incc);  
				matPanel.add(inMat); 
			}	
		}		
			
		// Label "H" = Hckelmatrix
		dgbl = new GridBagLayout();
		dcc = new GridBagConstraints();
		dispArea.setLayout(dgbl);
		dcc.fill = GridBagConstraints.BOTH;
		dcc.gridx = 2;      
		dcc.gridy = 0;    
		dcc.gridwidth = 1;
		dcc.gridheight = 1;
		dgbl.setConstraints(hLab, dcc);
		dispArea.add(hLab);
		
		// Zeilen-Nummerierung der Inputmatrix
		dcc.gridx = 2;
		dcc.gridy = 2;  
		dcc.gridwidth = 1;
		dcc.gridheight = size;
		dgbl.setConstraints(zNumH, dcc);
		dispArea.add(zNumH);  
				
		// Spalten-Nummerierung der Hckelmatrix
		dcc.gridx = 3;
		dcc.gridy = 1;   
		dcc.gridwidth = size;
		dcc.gridheight = 1;
		dgbl.setConstraints(spNumH, dcc);
		dispArea.add(spNumH);
		
		// Display Hckel-Matrix
		dcc.gridx = 3;
		dcc.gridy = 2;   
		dcc.gridwidth = size;
		dcc.gridheight = size;
		dgbl.setConstraints(matPanel, dcc);
		dispArea.add(matPanel);	
		
		EigenvalueDecomposition eig = hMat.eig();  // Eigenwert-Bestimmung
		E = eig.getD();  // Eigenwert-JamaMatrix
		eigW = E.getArray();  // 2D-Array von Doubles der Eigenwerte
		eigMat = new Matrix(eigW);  // Eigenwert-Labelmatrix
		
		System.out.println(" Eigenwerte: ");  // Konsolen-Ausgabe
      E.print(5, 3);		
				
		V = eig.getV(); // Eigenvektor-JamaMatrix  
      System.out.println(" Eigenvektor-Matrix: ");   // Konsolen-Ausgabe
      V.print(5, 3);
		eigVec = V.getArray();  // 2D-Array von Doubles der Eigenvektoren
		vecMat = new Matrix(eigVec); // Eigenvektor-Labelmatrix  
				
		// Label "V" = Eigenvektor-Matrix
		dcc.gridx = 2; 
		dcc.gridy = 6 + size;
		dcc.gridwidth = 1;
		dcc.gridheight = 1;
		dgbl.setConstraints(vLab, dcc);
		dispArea.add(vLab);
		
		// Zeilen-Nummerierung der Eigenvektor-Matrix
		dcc.gridx = 2;
		dcc.gridy = 7 + size;  
		dcc.gridwidth = 1;
		dcc.gridheight = size;
		dgbl.setConstraints(zNumV, dcc);
		dispArea.add(zNumV);  
		
		// Spalten-Nummerierung der Vektormatrix
		dcc.gridx = 3;
		dcc.gridy = 6 + size;  
		dcc.gridwidth = 1;
		dcc.gridheight = 1;
		dgbl.setConstraints(spNumV, dcc);
		dispArea.add(spNumV);		
			
		// Display Vektormatrix
		dcc.gridx = 3;  // statt 3
		dcc.gridy = 7 + size;  
		dcc.gridwidth = 1;  
		dcc.gridheight = size;
		
		vecMat.roundD(acc); 
		dgbl.setConstraints(vecMat, dcc); 
		dispArea.add(vecMat);  
		
		// Label "E" = Eigenwerte
		dcc.gridx = 3 + size;  
		dcc.gridy = 5 + size;
		dcc.gridwidth = 1;	
		dcc.gridheight = 1;
		dgbl.setConstraints(eLab, dcc);
		dispArea.add(eLab);
		
		// Eigenwert-Spalte
		eigSpalte = new double[size][1];   
		for (int i = 0; i < size; i++) 
      {
			eigSpalte[i][0] = eigW[i][i];	
		}
		
		eigSM = new Matrix(eigSpalte);    
		eigSM.setColor(colRot);
		eigSM.roundD(acc);
		dcc.gridx = 3 + size;  
		dcc.gridy = 7 + size;  
		dcc.gridwidth = 1;
		dcc.gridheight = size;
		dgbl.setConstraints(eigSM, dcc);
		dispArea.add(eigSM);		     	
					
		// Control-Panel
		gbl = new GridBagLayout();
		controls.setLayout(gbl);
		
		cc = new GridBagConstraints();
		
		cc.gridx = 0;
		cc.gridy = 0;
		cc.gridwidth = 2;
		gbl.setConstraints(erg, cc);
		controls.add(erg);
		
		validate();
	}
	
	class OpenAction implements ActionListener 
   {
     public void actionPerformed(ActionEvent e) 
     {
       int retval = fChoose.showOpenDialog(FileWindow.this);
       if (retval == JFileChooser.APPROVE_OPTION) 
       {
         File f = fChoose.getSelectedFile();
         try 
         {
           DecimalFormat fmt = new DecimalFormat("0.0000");
           PrintWriter pW = new PrintWriter(new FileOutputStream(f));           
           E.print(pW, fmt, 5);
			  V.print(pW, fmt, 5);
           pW.close();
         } 
         catch (IOException ioex) 
         {
           System.out.println(e);
           System.exit(1);
         }
		 }
		         
     } //end actionPerformed
   } //end inner listener class OpenAction							
}




